#include "SafeInt.h"
#include <iostream>
using namespace std;

// Static member definitions
long SafeInt::MaxInt = 2147483647;

SafeInt::SafeInt( const long i ) { 

    if( i == MaxInt ) iData = i;
    if( i > MaxInt ) iData = MaxInt;
    if( i < -MaxInt ) iData = - MaxInt;
    if( (i >= (MaxInt*-1)) && (i <= MaxInt) ) iData = i;
}

SafeInt& SafeInt::operator = (const long op2 ) {

    if( (op2 >= (-MaxInt)) && (op2 <= MaxInt) ) iData = op2;
    return (*this);
}

SafeInt SafeInt::operator + (const SafeInt&  op2 ) {

    SafeInt result;
    result = iData + op2.iData; 
    return result;
}

SafeInt SafeInt::operator - (const SafeInt&  op2 ){
    
    SafeInt result;
    result = iData - op2.iData; 
    return result;
}

SafeInt SafeInt::operator * (const SafeInt&  op2 ){
    
    SafeInt result;
    if( (!iData) || (!op2.iData) ) return result;
    result = iData * op2.iData; 
    return result;
}

SafeInt SafeInt::operator / (const SafeInt&  op2 ){
    
    SafeInt result;
    if( (!iData) || (!op2.iData) ) return result;
    result = iData / op2.iData; 
    return result;

}

void SafeInt::Print() const {
     cout << "Int: " << iData << "\n";  
} 

const long MAX = 2147483647;


int main() {
SafeInt a , b, c;

a = 5;
c = a/b;
c.Print();

c = MAX ;
c.Print();

c = 0;
c = MAX + 1000;

a = 0;

c = a*b;

c.Print();

return 0;
}
